IF EXISTS (SELECT * FROM SYS.VIEWS WHERE NAME = 'V_EST_PED_ENVIO_SAP_PENDENTE')
BEGIN
	DROP VIEW V_EST_PED_ENVIO_SAP_PENDENTE
END

GO
GO
GO

--POSSVEIS STATUS DO PROTOCOLO
--1-COLETA		Este ser utilizado no primeiro envio ( Enviar dados dos produtos )
--2-PROCESSA	Este ser utilizado ao final da consistncia, quando estiver OK ( Sem os dados de produto )
--3-CANCELA		Este ser utilizado em caso de inconsistncia na conferncia ( Sem os dados de produto )
--4-REENVIO		Este ser utilizado em caso de um novo registro devido a inconsistncia, neste caso n haver coleta ( Enviar dados dos produtos )

CREATE VIEW
	[dbo].[V_EST_PED_ENVIO_SAP_PENDENTE]
AS
SELECT
	PED_PENDENTE.CD_PED

	, NF_ORIGEM.DT_EMI_NF 
	, NF_ORIGEM.NR_NF 
	, EST_NF_SERIE.SERIE 
	, PG_FORN_CD_FIL_FORN.CD_FIL_FORN 
	, NF_DEV.CD_FILIAL 
	, NF_DEV.CD_NF 
	, COALESCE(EST_PROD_FORN.CD_PROD_FORN,'NAO DEF') AS CD_PROD 
	, CASE WHEN COALESCE(LOTE.NR_LOTE,'LOT002') = '' THEN 'LOT002' ELSE COALESCE(LOTE.NR_LOTE,'LOT002') END AS NR_LOTE 
	, COALESCE(LOTE.DT_VALID,'20991231') AS DT_VALID 
	, COALESCE(NF_ORIGEM_IT_LOTE.QTDE_PROD,NF_ORIGEM_IT.QT_IT) AS QTDE_IT 
	, COALESCE(NF_DEV_IT_LOTE.QTDE_PROD,NF_DEV_IT.QT_IT) AS QTDE_IT_DEV 
	, 'ITECGYN' AS OPERADOR 
	, '' AS CONTATO 
	, NF_DEV.DT_EMI_NF AS DT_EMI_NF_DEV 
	, NF_DEV.NF_NF AS NR_NF_DEV 
	, SERIE_DEV.SERIE AS SERIE_DEV 
	, NF_DEV.VLR_NF AS VLR_NF_DEV 
	, (SELECT QT_EMB_COMPRA FROM UFD_EST_PROD_EMB_APRES(1,NF_DEV_IT.CD_PROD,NF_DEV.CD_CLI)) AS QT_EMB 
	, PED_PENDENTE.STATUS

	,(SELECT SUM(QT_IT) FROM EST_NF_ENT_IT WHERE CD_EMP = NF_ORIGEM.CD_EMP AND CD_FILIAL = NF_ORIGEM.CD_FILIAL AND CD_NF = NF_ORIGEM.CD_NF) AS QT_ORIG_TOTAL

	,(SELECT SUM(QT_IT) FROM EST_NF_SAI_IT WHERE CD_EMP = NF_DEV.CD_EMP AND CD_FILIAL = NF_DEV.CD_FILIAL AND CD_NF = NF_DEV.CD_NF) AS QT_DEV_TOTAL,
	GLB_MOV_OP.FLAG_MOV_PROD_VENCIDO
FROM
	EST_PED_VD_ENVIO_PENDENTE PED_PENDENTE
	INNER JOIN EST_NF_SAI_PED_VD PRE_FATURA_NF ON 		
		PED_PENDENTE.CD_EMP = PRE_FATURA_NF.CD_EMP 
		AND PED_PENDENTE.CD_FILIAL = PRE_FATURA_NF.CD_FILIAL 
		AND PED_PENDENTE.CD_PED = PRE_FATURA_NF.CD_PED 
	INNER JOIN EST_PED_VD_IT PRE_FATURA_IT ON 		
		PED_PENDENTE.CD_EMP = PRE_FATURA_IT.CD_EMP 
		AND PED_PENDENTE.CD_FILIAL = PRE_FATURA_IT.CD_FILIAL 
		AND PED_PENDENTE.CD_PED = PRE_FATURA_IT.CD_PED 
	INNER JOIN EST_NF_SAI NF_DEV ON 
		PRE_FATURA_NF.CD_EMP = NF_DEV.CD_EMP 
		AND PRE_FATURA_NF.CD_FILIAL = NF_DEV.CD_FILIAL 
		AND PRE_FATURA_NF.CD_NF = NF_DEV.CD_NF 
	INNER JOIN GLB_MOV_OP ON
		NF_DEV.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP
	INNER JOIN EST_NF_SAI_IT NF_DEV_IT ON 
		NF_DEV.CD_EMP = NF_DEV_IT.CD_EMP 
		AND NF_DEV.CD_FILIAL = NF_DEV_IT.CD_FILIAL 
		AND NF_DEV.CD_NF = NF_DEV_IT.CD_NF
		AND PRE_FATURA_IT.CD_PROD = NF_DEV_IT.CD_PROD
	INNER JOIN EST_NF_SERIE SERIE_DEV ON 
		NF_DEV.CD_EMP = SERIE_DEV.CD_EMP 
		AND NF_DEV.CD_NF_SERIE = SERIE_DEV.CD_NF_SERIE 
	INNER JOIN EST_NF_ENT_EST_PED_VD PED_ENT ON
		PED_PENDENTE.CD_EMP = PED_ENT.CD_EMP
		AND PED_PENDENTE.CD_FILIAL = PED_ENT.CD_FILIAL
		AND PED_PENDENTE.CD_PED = PED_ENT.CD_PED
	INNER JOIN EST_NF_ENT NF_ORIGEM ON
		PED_ENT.CD_EMP = NF_ORIGEM.CD_EMP
		AND PED_ENT.CD_FILIAL = NF_ORIGEM.CD_FILIAL
		AND PED_ENT.CD_NF = NF_ORIGEM.CD_NF
	INNER JOIN EST_NF_ENT_IT NF_ORIGEM_IT ON
		NF_ORIGEM.CD_EMP = NF_ORIGEM_IT.CD_EMP
		AND NF_ORIGEM.CD_FILIAL = NF_ORIGEM_IT.CD_FILIAL
		AND NF_ORIGEM.CD_NF = NF_ORIGEM_IT.CD_NF
		AND PRE_FATURA_IT.CD_PROD = NF_ORIGEM_IT.CD_PROD 
		AND PRE_FATURA_IT.CD_NF_REF = NF_ORIGEM_IT.CD_NF
	LEFT JOIN EST_NF_ENT_IT_EST_PROD_CPL_LOTE AS NF_ORIGEM_IT_LOTE ON 
		NF_ORIGEM_IT.CD_EMP = NF_ORIGEM_IT_LOTE.CD_EMP 
		AND NF_ORIGEM_IT.CD_FILIAL = NF_ORIGEM_IT_LOTE.CD_FILIAL 
		AND NF_ORIGEM_IT.CD_NF = NF_ORIGEM_IT_LOTE.CD_NF 
		AND NF_ORIGEM_IT.CD_PROD = NF_ORIGEM_IT_LOTE.CD_PROD 
	INNER JOIN EST_NF_SERIE ON
		NF_ORIGEM.CD_EMP = EST_NF_SERIE.CD_EMP 
		AND NF_ORIGEM.CD_NF_SERIE = EST_NF_SERIE.CD_NF_SERIE
	INNER JOIN PG_FORN_CD_FIL_FORN ON 
		NF_DEV.CD_EMP = PG_FORN_CD_FIL_FORN.CD_EMP 
		AND NF_DEV.CD_FILIAL = PG_FORN_CD_FIL_FORN.CD_FILIAL 
		AND NF_DEV.CD_CLI = PG_FORN_CD_FIL_FORN.CD_FORN
	LEFT JOIN EST_NF_SAI_IT_EST_PROD_CPL_LOTE NF_DEV_IT_LOTE ON 
		NF_DEV_IT.CD_EMP = NF_DEV_IT_LOTE.CD_EMP 
		AND NF_DEV_IT.CD_FILIAL = NF_DEV_IT_LOTE.CD_FILIAL 
		AND NF_DEV_IT.CD_NF = NF_DEV_IT_LOTE.CD_NF 
		AND NF_DEV_IT.CD_PROD = NF_DEV_IT_LOTE.CD_PROD
	LEFT JOIN EST_PROD_CPL_LOTE LOTE ON
		NF_DEV_IT_LOTE.CD_EMP = LOTE.CD_EMP
		AND NF_DEV_IT_LOTE.CD_FILIAL = LOTE.CD_FILIAL
		AND NF_DEV_IT_LOTE.CD_PROD = LOTE.CD_PROD
		AND NF_DEV_IT_LOTE.CD_LOTE = LOTE.CD_LOTE
	LEFT JOIN EST_PROD_FORN ON 
		NF_DEV.CD_EMP = EST_PROD_FORN .CD_EMP 
		AND NF_DEV.CD_CLI = EST_PROD_FORN.CD_FORN 
		AND NF_DEV_IT.CD_PROD = EST_PROD_FORN.CD_PROD